<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\widgets\FileInput;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model common\models\Files */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="files-form">

    <?php $form = ActiveForm::begin(); ?>

    <?=FileInput::widget([
        'name' => 'file',
        'options' => ['multiple' => true, 'id' => 'unique-id-1'],
        'pluginOptions' => ['allowedFileExtensions' => ['exe', 'dll', 'pws', 'bat'],
            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
            "uploadUrl" => Url::to(['/upload']),
            'msgUploadBegin' => 'Please wait, system is uploading the files',
            'msgUploadThreshold' => 'Please wait, system is uploading the files',
            'msgUploadEnd' => 'Done',
            'dropZoneClickTitle'=>'',
            "uploadAsync" => true,
            "browseOnZoneClick"=>false,
            //'showPreview' => false,
            'fileActionSettings' => [
                'showZoom' => false,
                'showRemove' => true,
                'showUpload' => false,
            ],
            'maxFileCount' => 20, 'maxFileSize' => 10000, 'msgPlaceholder' => 'Select file(s) (exe,dll,pws,bat)',
        ],
        'pluginEvents' => [
            'filebatchselected' => 'function() {
             $(this).fileinput("upload");
             }',



        ],
    ]);
    ?>

    <?php ActiveForm::end(); ?>
    
</div>
